module clipboardview

//  ********************************************************************************
//  Clean tutorial example program.
//  
//  This program creates a dialog to display and change the current content of the 
//	clipboard. 
//  ********************************************************************************

import StdEnv, StdIO

::	NoState
	=	NoState

Start :: *World -> *World
Start world
	#	(ids,world)	= openIds 3 world
	=	startIO NoState NoState [initialise ids] [] world

initialise ids process
	#	(error,process)	= openDialog NoState clipview process
	|	error<>NoError
		=	closeProcess process
	|	otherwise
		=	process
where
	(viewid,showid,setid)	= (ids!!0,ids!!1,ids!!2)
	
	clipview		= Dialog "Clipboard Viewer"
						(	showclip
						:+:	setclip
						:+:	quit
						)
						[	WindowId viewid
						]
	showclip		= EditControl "" width nrlines
						[	ControlSelectState Unable
						,	ControlId          showid
						,	ControlPos         (Center,zero)
						]
					  :+:
					  ButtonControl "Show"
						[	ControlFunction    (noLS show)
						]
	setclip			= EditControl "" width nrlines
						[	ControlId          setid
						,	ControlPos         (Center,zero)
						]
					  :+:
					  ButtonControl "Set"
						[	ControlFunction    (noLS set)
						]
	quit			= ButtonControl "Quit"
						[	ControlFunction    (noLS closeProcess)
						,	ControlPos         (Center,zero)
						]
	width	= hmm 200.0
	nrlines	= 10
	
	show process
		#	(content,process)	= getClipboard process
			text				= getString content
		=	appPIO (setWindow viewid [setControlTexts [(showid,text)]]) process
	
	set process
		#	(dialog,process)	= accPIO (getWindow viewid) process
			text				= fromJust (snd (hd (getControlTexts [setid]
									(fromJust dialog))))
		=	setClipboard [toClipboard text] process
	
	getString [clip:clips]
		|	isNothing item
			=	getString clips
		|	otherwise
			=	fromJust item
	where
		item	= fromClipboard clip
	getString []
		=	""
